/*
 * @(#)CERFactory.java  1.0  2006-01-18
 *
 * Copyright (c) 2003 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.hslu.cm.cer;

import ch.hslu.cm.cer.diagram.*;
import ch.hslu.cm.cer.model.*;
import org.jhotdraw.draw.*;
import org.jhotdraw.draw.connector.ChopRectangleConnector;
import org.jhotdraw.draw.connector.StickyRectangleConnector;
import org.jhotdraw.draw.decoration.ArrowTip;
import org.jhotdraw.draw.liner.SlantedLiner;
import org.jhotdraw.draw.locator.BezierLabelLocator;
import org.jhotdraw.xml.DefaultDOMFactory;
/**
 * CERFactory.
 * 
 * 
 * @author Werner Randelshofer
 * @version 2006-01-18 Created.
 */
public class CERFactory extends DefaultDOMFactory {
    private final static Object[][] classTagArray = {
        // Old names for backwards compatibility
        { ConceptualERModel.class, "GERM" },
        { CERAttribute.class, "attribute" },
        { CERRelationshipSet.class, "rel" },
        { CEREntitySet.class, "entity" },
        { CERConnection.class, "conn" },
        { CERISA.class, "isa" },

        { ConceptualERDiagram.class, "GERD" },
        { CERRelationshipSetFigure.class, "relF" },
        { CERAttributeFigure.class, "attributeF" },
        { CEREntitySetFigure.class, "entityF" },
        { CERConnectionFigure.class, "connF" },
        { CERISAFigure.class, "isaF" },
        { TextFigure.class, "textF" },
        { GroupFigure.class, "g" },
        { TextAreaFigure.class, "ta" },
        
        { CERAttributeConnector.class, "attrConn" },
        { CERGeneralizationConnector.class, "generaliConn" },
        { CERSpecializationConnector.class, "specialiConn" },
        { CERRelationshipSetConnector.class, "relConn" },
        { StickyRectangleConnector.class, "arectConnector" },
        { ChopRectangleConnector.class, "rectConnector" },
        { CEREntitySetConnector.class, "entityConnector" },
        { BezierLabelLocator.class, "polylabelLocator" },
        { SlantedLiner.class, "slantedLiner" },
        { CERConnectionLiner.class, "GERLiner" },
        { ArrowTip.class, "arrowTip" },
        { StickyRectangleConnector.class, "StickyChopConnector" },
        { ChopRectangleConnector.class, "ChopBoxConnector" },
        
        // New names
        { ConceptualERModel.class, "ConceptualERModel" },
        { CERAttribute.class, "Attribute" },
        { CERRelationshipSet.class, "RelationshipSet" },
        { CEREntitySet.class, "EntitySet" },
        { CERConnection.class, "Connection" },
        { CERISA.class, "ISA" },

        { ConceptualERDiagram.class, "ConceptualERDiagram" },
        { CERRelationshipSetFigure.class, "RelationshipSetFigure" },
        { CERAttributeFigure.class, "AttributeFigure" },
        { CEREntitySetFigure.class, "EntitySetFigure" },
        { CERConnectionFigure.class, "ConnectionFigure" },
        { CERISAFigure.class, "ISAFigure" },
        { TextFigure.class, "TextFigure" },
        { GroupFigure.class, "GroupFigure" },
        { TextAreaFigure.class, "TextAreaFigure" },
        
        { CERAttributeConnector.class, "AttributeConnector" },
        { CERGeneralizationConnector.class, "GeneralizationConnector" },
        { CERSpecializationConnector.class, "SpecializationConnector" },
        { CERRelationshipSetConnector.class, "RelationshipSetConnector" },
        { StickyRectangleConnector.class, "StickyRectangleConnector" },
        { ChopRectangleConnector.class, "ChopRectangleConnector" },
        { CEREntitySetConnector.class, "EntitySetConnector" },
        { BezierLabelLocator.class, "BezierLabelLocator" },
        { SlantedLiner.class, "SlantedLiner" },
        { CERConnectionLiner.class, "ConnectionLiner" },
        { ArrowTip.class, "ArrowTip" }
    };
    
    /** Creates a new instance. */
    public CERFactory() {
        for (Object[] o : classTagArray) {
            addStorableClass((String) o[1], (Class) o[0]);
        }
    }
}
